package gov.cms.grouper.snf.lego;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ActionWrapperTest {

  @Test
  public void testDoAction() {
    Function<Integer, Integer> increment = (num) -> ++num;
    int initValue = 0;
    final String key = "key";

    List<Triple<Integer, String, Function<Integer, Integer>>> entries =
        Arrays.asList(Triple.of(initValue, key, increment));

    ActionWrapper<String, Integer> action = new ActionWrapper<String, Integer>(entries);

    int expected = 1;
    int actual = action.doAction(key);
    Assertions.assertEquals(expected, actual);

    actual = action.getValue(key);

    Set<String> expectedKeys = SnfUtils.toSet(key);
    Set<String> keys = action.getAllKeys();

    Assertions.assertEquals(expectedKeys, keys);

  }

}
